#pragma once
#include "startup_configuration.h"

#include <yandex_io/libs/device/device.h>

#include <ctime>
#include <string>
#include <vector>

struct ResponseData {
    std::string UUID;
    std::string deviceID;
    std::vector<std::string> reportHosts;
    std::vector<std::string> startupHosts;
};

class ReportConfiguration {
public:
    ReportConfiguration(const std::time_t& _startTime, const std::vector<std::string>& reportHosts, YandexIO::IDevice& device);
    ReportConfiguration(const std::time_t& _startTime, const std::vector<std::string>& reportHosts,
                        const StartupConfiguration& startupConfiguration, const std::string& UUID, const std::string& deviceID);

    const std::string& getDeviceId() const;
    const std::string& getUuid() const;
    const std::string& getModel() const;
    const std::string& getDeviceType() const;
    const std::string& getRevision() const;

    std::string reportRequestURL(const std::string& reportHost) const;
    std::vector<std::string> reportRequestURLS() const;
    const std::vector<std::string>& reportHosts() const;

    std::time_t startTime_;

private:
    std::vector<std::string> reportHosts_;
    const std::string deviceID_;
    const std::string UUID_;
    const std::string analyticsSdkBuildType_ = "embedded_cpp";
    const std::string model_;
    const std::string appVersion_ = "100";
    const std::string appVersionName_ = "1.0";
    const std::string analyticsSdkVersionName_ = "1.0.0";
    const std::string manufacturer_ = "YANDEX";
    const std::string osVersion_ = "4.1.2";
    const std::string metricaAppID_;
    const std::string deviceType_ = "desktop";

    //"smart_speaker";
    const std::string appPlatform_ = "linux";
    const std::string apiKey_ = "eb7fac3b-c77b-45d2-82bc-2253dbc21642";
    const std::string revision_;
};
