#pragma once

#include "report_configuration.h"
#include "startup_configuration.h"

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/threading/steady_condition_variable.h>

#include <atomic>
#include <ctime>
#include <memory>
#include <mutex>
#include <string>
#include <utility>

class StartupClient {
private:
    const std::shared_ptr<YandexIO::IDevice> device_;
    StartupConfiguration config_;
    const unsigned int FIRST_RETRY_PERIOD_SEC_ = 5;
    const unsigned int RETRY_PERIOD_SEC_ = 30;
    std::mutex mutex_;
    quasar::SteadyConditionVariable conditionVariable_;

    static ResponseData parseStartupResponse(const std::string& httpResponse);

public:
    static std::unique_ptr<ReportConfiguration> getReportConfigFromBootstrap(std::shared_ptr<YandexIO::IDevice> device, const ResponseData& bootstrap, const StartupConfiguration& config);
    static std::optional<ResponseData> tryGetBootstrapConfig(std::shared_ptr<YandexIO::IDevice> device, const std::string& startupUrl);

    std::unique_ptr<ReportConfiguration> getReportConfig(std::atomic_bool& threadStopped);
    ResponseData getStartupConfig(std::atomic_bool& threadStopped);
    StartupClient(StartupConfiguration config, std::shared_ptr<YandexIO::IDevice> device);
};
