#include "startup_configuration.h"

#include <yandex_io/libs/metrica/base/utils.h>

#include <stdexcept>

std::string StartupConfiguration::startupRequestURL(const std::string& startupHost) const {
    std::ostringstream url;

    url << startupHost << "/analytics/startup";
    url << "?protocol_version=2";
    url << "&locale=ru_RU";
    url << "&query_hosts=2";

    url << "&analytics_sdk_build_type=" << urlencode(analyticsSdkBuildType);
    url << "&analytics_sdk_version_name=" << urlencode(analyticsSdkVersionName);
    url << "&api_key_128=" << urlencode(apiKey);
    url << "&app_id=" << urlencode(metricaAppID);
    url << "&app_platform=" << urlencode(appPlatform);
    url << "&app_version=" << urlencode(appVersion);
    url << "&app_version_name=" << urlencode(appVersionName);
    url << "&device_type=" << urlencode(deviceType);
    url << "&manufacturer=" << urlencode(manufacturer);
    url << "&model=" << urlencode(model);
    url << "&os_version=" << urlencode(osVersion);

    if (!UUID.empty()) {
        url << "&uuid=" << urlencode(UUID);
    }

    if (!deviceID.empty()) {
        url << "&deviceid=" << urlencode(deviceID);
    }

    return url.str();
}

std::string StartupConfiguration::systemOsVersion() {
    std::string osVersion;
    if (struct utsname name; ::uname(&name) == 0) {
        osVersion = name.release;
        osVersion += " ";
        osVersion += name.version;
    } else {
        YIO_LOG_WARN("Cannot get uname");
        osVersion = "UNKNOWN";
    }

    return osVersion;
}
