#pragma once

#include <yandex_io/libs/logging/logging.h>

#include <ctime>
#include <string>
#include <vector>

#include <sys/utsname.h>

struct StartupConfiguration {
    std::time_t startTime;
    std::string startupHost;
    std::string apiKey;
    std::string deviceID;
    std::string UUID;
    std::string model;
    std::string appVersion;
    std::string appVersionName;
    std::string metricaAppID;
    std::string deviceType = "desktop";
    std::string appPlatform = "linux";
    std::string manufacturer = "YANDEX";
    std::string revision;
    std::string osVersion = "UNKNOWN";

    std::string analyticsSdkBuildType = "embedded_cpp";
    std::string analyticsSdkVersionName = "1.0.0";

    std::string startupRequestURL(const std::string& startupHost) const;

    static std::string systemOsVersion();
};
