#pragma once

#include <yandex_io/libs/appmetrica/proto/metrica.pb.h>

#include <yandex_io/libs/metrica/base/metrica_session_provider.h>
#include <yandex_io/libs/threading/blocking_queue.h>

#include <variant>

class StopQueue {};

struct ReportOneEvent {
    ReportMessage_Session_Event event;
    std::map<std::string, std::string> environmentVariables;
    MetricaSessionProvider::Session session;

    ReportOneEvent(const ReportMessage_Session_Event& event,
                   std::map<std::string, std::string> envVars,
                   MetricaSessionProvider::Session session)
        : event(event)
        , environmentVariables(std::move(envVars))
        , session(session)
    {
    }

    ReportOneEvent() = default;
};

using queueElement = std::variant<ReportOneEvent, StopQueue>;
using blockingQueue = quasar::BlockingQueue<queueElement>;
