#pragma once

#include <cstdint>
#include <memory>
#include <vector>

namespace quasar {

    class IChannelSplitter {
    public:
        virtual ~IChannelSplitter() = default;
        /// Splits channels. Ignores specified # of mic channels, counting from the last.
        virtual void splitAndSkip(const std::vector<uint8_t>& rawData, std::vector<float>& inputMic, std::vector<float>& inputSpk, int skipLastMics) const = 0;
        virtual void getSeparateChannel(const std::vector<uint8_t>& rawData, int channelNumber, std::vector<int16_t>& channel) const = 0;

        static std::unique_ptr<IChannelSplitter> create(int micChannels, int spkChannels, int sampleSizeBytes);

        void split(const std::vector<uint8_t>& rawData, std::vector<float>& inputMic, std::vector<float>& inputSpk) const {
            splitAndSkip(rawData, inputMic, inputSpk, 0);
        }
    };

    using IChannelSplitterPtr = std::unique_ptr<IChannelSplitter>;

} // namespace quasar
