#include "crc32.h"

#include <library/cpp/digest/old_crc/crc.h>

#include <fstream>

using namespace quasar;

namespace quasar {

    Crc32::Crc32(uint32_t base)
        : value_(base)
    {
    }

    void Crc32::extend(std::string_view data) {
        extend(data.data(), data.size());
    }

    void Crc32::extend(const char* data, size_t size) {
        value_ = crc32(data, size, value_);
    }

    uint32_t Crc32::checksum() const {
        return value_;
    }

    void Crc32::processFile(const std::string& fileName)
    {
        std::ifstream file(fileName, std::fstream::binary);
        if (!file) {
            throw std::runtime_error("Failed to open file '" + fileName + "' for crc32 processing");
        }

        const size_t blockSize = 8192;
        char buffer[blockSize];

        do {
            file.read(buffer, blockSize);
            extend(buffer, file.gcount());
        } while (file);
    }

    uint32_t getCrc32(std::string_view data) {
        return crc32(data.data(), data.size());
    }

} // namespace quasar
