#pragma once

#include <string>
#include <string_view>

namespace quasar {

    class Crc32 {
    public:
        Crc32() = default;
        Crc32(uint32_t base);

        void extend(std::string_view data);
        void extend(const char* data, size_t size);
        void processFile(const std::string& fileName);

        uint32_t checksum() const;

    private:
        uint32_t value_ = 0;
    };

    uint32_t getCrc32(std::string_view data);

} // namespace quasar
