#include "directives.h"

using namespace quasar;

/* static members allocation */

const std::unordered_set<std::string> Directives::DIRECTIVES = {
    Directives::SEND_BUG_REPORT,
    Directives::MUSIC_PLAY,
    Directives::RADIO_PLAY,
    Directives::PLAYER_PAUSE,
    Directives::PLAYER_CONTINUE,
    Directives::PLAYER_NEXT_TRACK,
    Directives::PLAYER_PREVIOUS_TRACK,
    Directives::PLAYER_REPLAY,
    Directives::PLAYER_LIKE,
    Directives::PLAYER_DISLIKE,
    Directives::PLAYER_REWIND,
    Directives::SOUND_LOUDER,
    Directives::SOUND_QUITER,
    Directives::SOUND_MUTE,
    Directives::SOUND_UNMUTE,
    Directives::SOUND_SET_LEVEL,
    Directives::VIDEO_PLAY,
    Directives::NEXT_EPISODE_ANNOUNCE,
    Directives::SHOW_GALLERY,
    Directives::SHOW_SEASON_GALLERY,
    Directives::SHOW_TV_GALLERY,
    Directives::SHOW_DESCRIPTION,
    Directives::SHOW_PAY_PUSH_SCREEN,
    Directives::GO_HOME,
    Directives::GO_FORWARD,
    Directives::GO_BACKWARD,
    Directives::GO_UP,
    Directives::GO_DOWN,
    Directives::GO_TO_THE_BEGINNING,
    Directives::GO_TO_THE_END,
    Directives::GO_TOP,
    Directives::SET_TIMER,
    Directives::ALARMS_UPDATE,
    Directives::CANCEL_TIMER,
    Directives::PAUSE_TIMER,
    Directives::RESUME_TIMER,
    Directives::START_BLUETOOTH,
    Directives::STOP_BLUETOOTH,
    Directives::SCREEN_ON,
    Directives::SCREEN_OFF,
    Directives::ALARM_START,
    Directives::ALARM_STOP,
    Directives::ALARM_SET_SOUND,
    Directives::ALARM_RESET_SOUND,
    Directives::ALARM_SET_MAX_LEVEL,
    Directives::THEREMIN_PLAY,
    Directives::MORDOVIA_SHOW,
    Directives::MORDOVIA_COMMAND,
    Directives::TOF_TO_CSV_START,
    Directives::TOF_TO_CSV_STOP,
    Directives::ONBOARDING_SKIP,
    Directives::ONBOARDING_PLAY,
    Directives::START_MUSIC_RECOGNIZER,
    Directives::START_MULTIROOM,
    Directives::STOP_MULTIROOM,
    Directives::MULTIROOM_SEMANTIC_FRAME,
    Directives::AUDIO_PLAY,
    Directives::AUDIO_STOP,
    Directives::CHANGE_AUDIO,
    Directives::CHANGE_SUBTITLES,
    Directives::MESSENGER_CALL,
    Directives::SHOW_VIDEO_SETTINGS,
    Directives::NOTIFY,
    Directives::AUDIO_REWIND,
    Directives::TTS_PLAY_PLACEHOLDER,
    Directives::DRAW_LED_SCREEN,
    Directives::SETUP_RCU,
    Directives::SETUP_RCU_AUTO,
    Directives::SETUP_RCU_CHECK,
    Directives::SETUP_RCU_ADVANCED,
    Directives::SETUP_RCU_MANUAL,
    Directives::IOT_DISCOVERY_START,
    Directives::IOT_DISCOVERY_STOP,
    Directives::IOT_DISCOVERY_CREDENTIALS,
    Directives::CLEAR_QUEUE,
    Directives::SET_COOKIES,
    Directives::SUCCESS_STARTING_ONBOARDING,
    Directives::LISTEN,
    Directives::GLAGOL_METADATA,
    Directives::ALICE_REQUEST,
    Directives::ALICE_RESPONSE,
    Directives::BLUETOOTH_PLAYER_PAUSE,
    Directives::BLUETOOTH_PLAYER_PLAY,
    Directives::BLUETOOTH_PLAYER_NEXT,
    Directives::BLUETOOTH_PLAYER_PREV,
    Directives::DRAW_SCLED_ANIMATION,
    Directives::SHOW_CLOCK,
    Directives::HIDE_CLOCK,
    Directives::UPDATE_VOICE_PRINTS,
    Directives::MATCH_VOICE_PRINT,
    Directives::BIO_ADD_ACCOUNT,
    Directives::BIO_REMOVE_ACCOUNT,
    Directives::BIO_ADD_ACCOUNT2,
    Directives::BIO_REMOVE_ACCOUNT2,
    Directives::BIO_START_SOUND_ENROLLMENT,
    Directives::ENROLLMENT_START,
    Directives::ENROLLMENT_CANCEL,
    Directives::ENROLLMENT_FINISH,
    Directives::SOUND_FILE_PLAY,
    Directives::SOUND_FILE_STOP,
    Directives::START_FOREGROUND_ACTIVITY,
    Directives::PLAYBACK_PLAY,
    Directives::PLAYBACK_PAUSE,
    Directives::PLAYBACK_LIKE,
    Directives::PLAYBACK_DISLIKE,
    Directives::PLAYBACK_NEXT,
    Directives::PLAYBACK_PREV,
    Directives::PLAYBACK_REWIND,
    Directives::PLAYBACK_TOGGLE_PLAY_PAUSE,
};

bool Directives::contains(const std::string& name)
{
    return DIRECTIVES.count(name) > 0;
}
