#pragma once

#include <array>
#include <string>
#include <unordered_set>

namespace quasar {

    class Directives final {
    public:
        static bool contains(const std::string& name);

        static constexpr const char* SEND_BUG_REPORT = "send_bug_report";
        static constexpr const char* MUSIC_PLAY = "music_play";
        static constexpr const char* RADIO_PLAY = "radio_play";
        static constexpr const char* STOP_LEGACY_PLAYER = "stop_legacy_player";
        static constexpr const char* PLAYER_PAUSE = "player_pause";
        static constexpr const char* PLAYER_CONTINUE = "player_continue";
        static constexpr const char* PLAYER_NEXT_TRACK = "player_next_track";
        static constexpr const char* PLAYER_PREVIOUS_TRACK = "player_previous_track";
        static constexpr const char* PLAYER_REPLAY = "player_replay";
        static constexpr const char* PLAYER_LIKE = "player_like";
        static constexpr const char* PLAYER_DISLIKE = "player_dislike";
        static constexpr const char* PLAYER_REWIND = "player_rewind";
        static constexpr const char* SOUND_LOUDER = "sound_louder";
        static constexpr const char* SOUND_QUITER = "sound_quiter";
        static constexpr const char* SOUND_MUTE = "sound_mute";
        static constexpr const char* SOUND_UNMUTE = "sound_unmute";
        static constexpr const char* SOUND_SET_LEVEL = "sound_set_level";
        static constexpr const char* VIDEO_PLAY = "video_play";
        static constexpr const char* NEXT_EPISODE_ANNOUNCE = "next_episode_announce";
        static constexpr const char* SHOW_GALLERY = "show_gallery";
        static constexpr const char* SHOW_SEASON_GALLERY = "show_season_gallery";
        static constexpr const char* SHOW_TV_GALLERY = "show_tv_gallery";
        static constexpr const char* SHOW_DESCRIPTION = "show_description";
        static constexpr const char* SHOW_PAY_PUSH_SCREEN = "show_pay_push_screen";
        static constexpr const char* GO_HOME = "go_home";
        static constexpr const char* GO_FORWARD = "go_forward";
        static constexpr const char* GO_BACKWARD = "go_backward";
        static constexpr const char* GO_UP = "go_up";
        static constexpr const char* GO_DOWN = "go_down";
        static constexpr const char* GO_TO_THE_BEGINNING = "go_to_the_beginning";
        static constexpr const char* GO_TO_THE_END = "go_to_the_end";
        static constexpr const char* GO_TOP = "go_top";
        static constexpr const char* SET_TIMER = "set_timer";
        static constexpr const char* ALARMS_UPDATE = "alarms_update";
        static constexpr const char* CANCEL_TIMER = "cancel_timer";
        static constexpr const char* PAUSE_TIMER = "pause_timer";
        static constexpr const char* RESUME_TIMER = "resume_timer";
        static constexpr const char* START_BLUETOOTH = "start_bluetooth";
        static constexpr const char* STOP_BLUETOOTH = "stop_bluetooth";
        static constexpr const char* SCREEN_ON = "screen_on";
        static constexpr const char* SCREEN_OFF = "screen_off";
        static constexpr const char* ALARM_START = "alarm_start";
        static constexpr const char* ALARM_STOP = "alarm_stop";
        static constexpr const char* ALARM_SET_SOUND = "alarm_set_sound";
        static constexpr const char* ALARM_RESET_SOUND = "alarm_reset_sound";
        static constexpr const char* ALARM_SET_MAX_LEVEL = "alarm_set_max_level";
        static constexpr const char* THEREMIN_PLAY = "theremin_play";
        static constexpr const char* MORDOVIA_SHOW = "mordovia_show";
        static constexpr const char* MORDOVIA_COMMAND = "mordovia_command";
        static constexpr const char* TOF_TO_CSV_START = "tof_to_csv_start";
        static constexpr const char* TOF_TO_CSV_STOP = "tof_to_csv_stop";
        static constexpr const char* ONBOARDING_PLAY = "onboarding_play";
        static constexpr const char* ONBOARDING_SKIP = "onboarding_skip";
        static constexpr const char* START_MUSIC_RECOGNIZER = "start_music_recognizer";
        static constexpr const char* START_MULTIROOM = "start_multiroom";
        static constexpr const char* STOP_MULTIROOM = "stop_multiroom";
        static constexpr const char* MULTIROOM_SEMANTIC_FRAME = "multiroom_semantic_frame";
        static constexpr const char* AUDIO_PLAY = "audio_play";
        static constexpr const char* AUDIO_STOP = "audio_stop";
        static constexpr const char* CHANGE_AUDIO = "change_audio";
        static constexpr const char* CHANGE_SUBTITLES = "change_subtitles";
        static constexpr const char* MESSENGER_CALL = "messenger_call";
        static constexpr const char* SHOW_VIDEO_SETTINGS = "show_video_settings";
        static constexpr const char* NOTIFY = "notify";
        static constexpr const char* AUDIO_REWIND = "audio_player_rewind";
        static constexpr const char* TTS_PLAY_PLACEHOLDER = "tts_play_placeholder";
        static constexpr const char* DRAW_LED_SCREEN = "draw_led_screen";
        static constexpr const char* SETUP_RCU = "setup_rcu";
        static constexpr const char* SETUP_RCU_AUTO = "setup_rcu_auto";
        static constexpr const char* SETUP_RCU_CHECK = "setup_rcu_check";
        static constexpr const char* SETUP_RCU_ADVANCED = "setup_rcu_advanced";
        static constexpr const char* SETUP_RCU_MANUAL = "setup_rcu_manual";
        static constexpr const char* IOT_DISCOVERY_START = "iot_discovery_start";
        static constexpr const char* IOT_DISCOVERY_STOP = "iot_discovery_stop";
        static constexpr const char* IOT_DISCOVERY_CREDENTIALS = "iot_discovery_credentials";
        static constexpr const char* CLEAR_QUEUE = "clear_queue";
        static constexpr const char* SET_COOKIES = "set_cookies";
        static constexpr const char* SUCCESS_STARTING_ONBOARDING = "success_starting_onboarding";
        static constexpr const char* ONBOARDING_STARTING_CRITICAL_UPDATE = "onboarding_starting_critical_update";
        static constexpr const char* LISTEN = "listen";
        static constexpr const char* TYPE = "type";
        static constexpr const char* TYPE_SILENT = "type_silent";
        static constexpr const char* GLAGOL_METADATA = "set_glagol_metadata";
        static constexpr const char* ALICE_REQUEST = "alice_request";
        static constexpr const char* ALICE_RESPONSE = "alice_response";
        static constexpr const char* BLUETOOTH_PLAYER_PAUSE = "bluetooth_player_pause";
        static constexpr const char* BLUETOOTH_PLAYER_PLAY = "bluetooth_player_play";
        static constexpr const char* BLUETOOTH_PLAYER_NEXT = "bluetooth_player_next";
        static constexpr const char* BLUETOOTH_PLAYER_PREV = "bluetooth_player_prev";
        static constexpr const char* DRAW_SCLED_ANIMATION = "draw_scled_animations";
        static constexpr const char* AUDIO_CLIENT_NEXT_TRACK = "audio_client_next_track";
        static constexpr const char* AUDIO_CLIENT_PREV_TRACK = "audio_client_prev_track";
        static constexpr const char* SHOW_HOME_SCREEN = "show_home_screen";
        static constexpr const char* SHOW_CLOCK = "show_clock";
        static constexpr const char* HIDE_CLOCK = "hide_clock";
        static constexpr const char* UPDATE_VOICE_PRINTS = "update_voice_prints";
        static constexpr const char* MATCH_VOICE_PRINT = "match_voice_print";
        static constexpr const char* BIO_ADD_ACCOUNT = "alice.multiaccount.add_account";
        static constexpr const char* BIO_REMOVE_ACCOUNT = "alice.multiaccount.remove_account";
        static constexpr const char* BIO_ADD_ACCOUNT2 = "multiaccount_add_account";
        static constexpr const char* BIO_REMOVE_ACCOUNT2 = "multiaccount_remove_account";
        static constexpr const char* BIO_START_SOUND_ENROLLMENT = "bio_start_sound_enrollment";
        static constexpr const char* ENROLLMENT_START = "enrollment_start";
        static constexpr const char* ENROLLMENT_CANCEL = "enrollment_cancel";
        static constexpr const char* ENROLLMENT_FINISH = "enrollment_finish";
        static constexpr const char* SOUND_FILE_PLAY = "sound_file_play";
        static constexpr const char* SOUND_FILE_STOP = "sound_file_stop";
        static constexpr const char* START_FOREGROUND_ACTIVITY = "start_foreground_activity";
        static constexpr const char* PLAYBACK_PLAY = "playback_play";
        static constexpr const char* PLAYBACK_PAUSE = "playback_pause";
        static constexpr const char* PLAYBACK_LIKE = "playback_like";
        static constexpr const char* PLAYBACK_DISLIKE = "playback_dislike";
        static constexpr const char* PLAYBACK_NEXT = "playback_next";
        static constexpr const char* PLAYBACK_PREV = "playback_prev";
        static constexpr const char* PLAYBACK_REWIND = "playback_rewind";
        static constexpr const char* PLAYBACK_TOGGLE_PLAY_PAUSE = "playback_toggle_play_pause";

    private:
        static const std::unordered_set<std::string> DIRECTIVES;
    };

} /* namespace quasar */
