#pragma once

#include <chrono>
#include <cstdint>

namespace quasar {

    class HourRange {
    public:
        using TimePoint = std::chrono::time_point<std::chrono::system_clock>;

        HourRange(int minHour, int maxHour, int utcTimezoneShift);
        HourRange(int minHour, int maxHour);

        void setTimezoneShiftHours(int shiftHours);
        int getTimezoneShiftHours() const;
        bool containsUtcHour(int utcHour) const;

        bool containsTimestamp(TimePoint timestamp) const;

        HourRange() = default;

    private:
        int getShiftedUtcMinHour() const;
        int getShiftedUtcMaxHour() const;

        int minHour_ = 0, maxHour_ = 23;

        bool useSystemTime_ = false;
        int utcTimezoneShiftHours_ = 0;
    };

} // namespace quasar
