#include "named_callback_queue.h"

#include <yandex_io/libs/logging/logging.h>

#include <utility>

YIO_DEFINE_LOG_MODULE("callback_queue");

using namespace quasar;

NamedCallbackQueue::NamedCallbackQueue(std::string name)
    : NamedCallbackQueue(std::move(name), 1000, nullptr, nullptr)
{
}

NamedCallbackQueue::NamedCallbackQueue(std::string name, size_t maxSize, Callback onOverflowCallback, Callback onBecomeNormalCallback)
    : CallbackQueue(
          maxSize,
          (onOverflowCallback ? std::move(onOverflowCallback) : [this](size_t sz) { onOverflow(sz); }),
          std::move(onBecomeNormalCallback))
    , name_(std::move(name))
{
}

NamedCallbackQueue::~NamedCallbackQueue() {
    Y_VERIFY(!isWorkingThread(), "Destory named callback queue inside itself: %s", name().c_str());
    destroy();
}

std::string NamedCallbackQueue::name() const {
    if (name_.empty()) {
        return CallbackQueue::name();
    }
    return name_;
}

void NamedCallbackQueue::onOverflow(size_t queueSize) noexcept {
    YIO_LOG_ERROR_EVENT("NamedCallbackQueue.Overflow", "CallbackQueue overflow " << name() << ", queue size is " << queueSize);
}

void NamedCallbackQueue::onException(std::exception_ptr exptr) noexcept {
    try {
        if (exptr) {
            std::rethrow_exception(exptr);
        }
    } catch (const std::exception& ex) {
        YIO_LOG_ERROR_EVENT("NamedCallbackQueue.Exception", "Unhandled exception in \"" << name() << "\" CallbackQueue: " << ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("NamedCallbackQueue.UnknownError", "Unexpected exception in \"" << name() << "\" CallbackQueue");
    }
}
