#pragma once

#include <yandex_io/libs/threading/callback_queue.h>

namespace quasar {
    class NamedCallbackQueue: public CallbackQueue {
    public:
        explicit NamedCallbackQueue(std::string name);
        NamedCallbackQueue(std::string name, size_t maxSize, Callback onOverflowCallback = nullptr, Callback onBecomeNormalCallback = nullptr);
        ~NamedCallbackQueue();

        std::string name() const override;

    protected:
        virtual void onOverflow(size_t queueSize) noexcept;
        void onException(std::exception_ptr exptr) noexcept override;

    private:
        const std::string name_;
    };
} // namespace quasar
