#pragma once
#include <string>

class QuasarService {
public:
    virtual ~QuasarService() = default;

    virtual std::string getServiceName() const = 0;

    virtual std::string getThreadName() const {
        return getServiceName().substr(0, 5);
    }; // Should not be longer than 5 chars

    // Start async servers/threads
    virtual void start() = 0;

    // Finalize/join async servers/threads at graceful shutdown
    virtual void stop() {
    }

    // Method for synchronization. Should be used to make sure that service
    // is connected to services it depends on
    virtual void sync() {
    }
};
