#include "retry_delay_counter.h"

#include <algorithm>

using namespace quasar;

RetryDelayCounter::RetryDelayCounter() {
    reset();
}

void RetryDelayCounter::setSettings(Settings settings) {
    settings_ = settings;
    settings_.init = std::min(settings_.max, settings_.init);
    reset();
}

void RetryDelayCounter::increase() {
    delay_ = std::min(settings_.offset + settings_.factor * delay_, settings_.max);
}

void RetryDelayCounter::reset() {
    delay_ = settings_.init;
}

std::chrono::milliseconds RetryDelayCounter::get() const {
    return delay_;
}
