#pragma once
#include <chrono>

namespace quasar {

    class RetryDelayCounter {
    public:
        struct Settings {
            /*
             * Delay is set to 'init' after each reset() call
             *
             * The rest is used in formula :
             * 'delay_' = min('offset' + 'factor' * 'delay_', 'max');
             */
            std::chrono::milliseconds init = std::chrono::seconds(4);
            std::chrono::milliseconds offset = std::chrono::seconds(0);
            int factor = 2;
            std::chrono::milliseconds max = std::chrono::minutes(1);
        };

        RetryDelayCounter();

        void setSettings(Settings settings);

        /**
         * @brief increase delay in 'factor' times up to 'max' value (with offset)
         */
        void increase();

        /**
         * @brief reset delay to 'init' value
         */
        void reset();

        std::chrono::milliseconds get() const;

        inline const Settings& getSettings() const {
            return settings_;
        }

    private:
        std::chrono::milliseconds delay_;
        Settings settings_;
    };

} // namespace quasar
