#include "ble_decoder.h"

#include <yandex_io/libs/cryptography/cryptography.h>
#include <yandex_io/libs/device_cryptography/device_cryptography.h>
#include <yandex_io/libs/logging/logging.h>

namespace quasar {
    std::vector<unsigned char> decryptBleCredentials(const proto::EncryptedSetupCredentialsMessage& msg,
                                                     YandexIO::DeviceCryptography& deviceCryptography) {
        std::vector<unsigned char> result;
        const std::string DK = deviceCryptography.decrypt(msg.c());
        YIO_LOG_DEBUG("DK length: " << DK.length());
        const std::string M2 = Cryptography::hashWithHMAC_SHA256(msg.ciphertext(), DK);
        YIO_LOG_DEBUG("M2 length: " << M2.length());
        if (msg.m() != M2) {
            YIO_LOG_WARN("M != M2");
            throw std::runtime_error("Cannot decrypt ble credentials. M != M2");
        }
        const std::string_view IV(DK.data(), 16);
        YIO_LOG_DEBUG("IV length: " << IV.length());
        const std::string_view key(DK.data() + 16, DK.size() - 16);
        YIO_LOG_DEBUG("key length: " << key.length());
        const std::string decryptedCredentials = Cryptography::decryptAES(IV, key, msg.ciphertext());
        YIO_LOG_DEBUG("decryptedCredentials length: " << decryptedCredentials.length());
        result.assign(decryptedCredentials.begin(), decryptedCredentials.end());

        return result;
    }
} // namespace quasar
