#pragma once

namespace quasar {

    /**
     * @brief This class describes the Device bluetooth capabilities
     */
    class BluetoothCapabilities {
    public:
        /**
         * @return true if device is able to connect to SINK devices and Stream Out; false - if can't Stream Out
         */
        virtual bool hasStreamOut() const = 0;

        /**
         * @return true if device is able to be Discoverable and Connectable, so Source devices will be able to connect
         *         and stream out on this device (it's stream in for this device). false - in other cases
         */
        virtual bool hasStreamIn() const = 0;

        /**
         * @return true if device supports Bluetooth Low Energy, otherwise returns false
         */
        virtual bool hasBle() const = 0;

        /**
         * @return true if device can Stream Out only (it's not able to stream in). false - all others cases.
         */
        bool isStreamOutOnly() const {
            return hasStreamOut() && !hasStreamIn();
        }

        /**
         * @return true if device can Stream In only (it's not able to stream out). false - all others cases.
         */
        bool isStreamInOnly() const {
            return hasStreamIn() && !hasStreamOut();
        }
    };

} /* namespace quasar */
