#pragma once

#include <yandex_io/libs/bluetooth/gatt/i_gatt_characteristics.h>
#include <yandex_io/libs/bluetooth/gatt/i_gatt_service.h>

#include <vector>

struct ManufacturerData {
    uint16_t id;
    std::vector<uint8_t> data;
};

class BluetoothLE {
public:
    BluetoothLE() = default;
    virtual ~BluetoothLE() = default;

    /**
     * Sets manufacturer data for advertising package
     * @param manufacturerData
     */
    virtual void setManufacturerData(ManufacturerData manufacturerData) = 0;

    /**
     * Adds IGattService to be provided by GATT server
     * @param service
     */
    virtual void addGattService(std::shared_ptr<IGattService> service) = 0;

    /**
     * Adds IGattCharacteristic to the specified IGattService
     * @param gattServiceName
     * @param characteristic
     */
    virtual void addGattCharacteristic(const std::string& gattServiceName, std::shared_ptr<IGattCharacteristic> characteristic) = 0;

    /**
     * Starts advertising. All services and characteristics should be added by this moment
     */
    virtual void startAdvertising() = 0;

    /**
     * Stops advertising
     */
    virtual void stopAdvertising() = 0;
};
