#pragma once

#include "common.h"

#include <yandex_io/libs/bluetooth/bluez/dbus/Adapter.proxy.h>

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

namespace bluez_impl {

    class BluetoothAdapter final: public sdbus::ProxyInterfaces<org::bluez::Adapter1_proxy> {
    public:
        static constexpr auto POWERED_PROPERTY_NAME = "Powered";
        static constexpr auto DISCOVERABLE_PROPERTY_NAME = "Discoverable";
        static constexpr auto PAIRABLE_PROPERTY_NAME = "Pairable";

        explicit BluetoothAdapter(std::string objectPath)
            : sdbus::ProxyInterfaces<org::bluez::Adapter1_proxy>(BLUEZ_BUS, std::move(objectPath))
        {
            registerProxy();
        }
        ~BluetoothAdapter() {
            unregisterProxy();
        }
    };

} // namespace bluez_impl
