#include "bluetooth_device.h"

#include <yandex_io/libs/logging/logging.h>

using namespace bluez_impl;

BluetoothDevice::BluetoothDevice(std::string objectPath)
    : sdbus::ProxyInterfaces<org::bluez::Device1_proxy>(BLUEZ_BUS, std::move(objectPath))
{
    registerProxy();
    btNetwork_.name = Name();
    btNetwork_.addr = Address();
    btNetwork_.role = Bluetooth::BtRole::SOURCE;
}

BluetoothDevice::~BluetoothDevice()
{
    unregisterProxy();
}

Bluetooth::BtNetwork BluetoothDevice::getBtNetwork() const {
    return btNetwork_;
}
