#pragma once

#include "common.h"

#include <yandex_io/libs/bluetooth/bluez/dbus/Device.proxy.h>

#include <yandex_io/libs/bluetooth/bluetooth.h>

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

namespace bluez_impl {

    class BluetoothDevice final: public sdbus::ProxyInterfaces<org::bluez::Device1_proxy> {
    public:
        explicit BluetoothDevice(std::string objectPath);

        ~BluetoothDevice();

        /**
         * @note use this method to get device's name and MAC address
         * Avoid Name() and Address() methods of base class
         * @return Bluetooth::BtNetwork
         */
        Bluetooth::BtNetwork getBtNetwork() const;

    private:
        Bluetooth::BtNetwork btNetwork_;
    };

} // namespace bluez_impl
