#pragma once

#include "connection_monitor.h"
#include "gatt_application.h"
#include "gatt_manager.h"
#include "le_advertisement.h"
#include "le_advertising_manager.h"
#include "le_advertising_reenabler.h"

#include <yandex_io/libs/bluetooth/bluetooth_le.h>

#include <yandex_io/libs/base/named_callback_queue.h>

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

#include <memory>
#include <vector>

namespace quasar {

    class BluezBLEImpl: public BluetoothLE {
    public:
        explicit BluezBLEImpl();
        ~BluezBLEImpl();

        void setManufacturerData(ManufacturerData manufacturerData) override;

        void addGattService(std::shared_ptr<IGattService> service) override;

        void addGattCharacteristic(const std::string& gattServiceName, std::shared_ptr<IGattCharacteristic> characteristic) override;

        void startAdvertising() override;

        void stopAdvertising() override;

    private:
        void acquireAdapter();
        void releaseAdapter();

        void setAdvertisingInterval(uint32_t min, uint32_t max);

    private:
        const static sdbus::ObjectPath ORG_PATH;
        const static sdbus::ObjectPath PROFILE_PATH;
        const static sdbus::ObjectPath ADVERT_PATH;
        const static sdbus::ObjectPath GATT_APP_PATH;

        const std::string adapterPath_;

        NamedCallbackQueue callbackQueue_{"BluezBLEImpl"};

        std::unique_ptr<sdbus::IConnection> systemBusConnection_;
        bluez_impl::ConnectionMonitor connectionMonitor_;
        bluez_impl::GattApplication gattApplication_;

        std::unique_ptr<bluez_impl::LEAdvertisingManager> advertisingManager_;
        std::unique_ptr<bluez_impl::GattManager> gattManager_;

        ManufacturerData manufacturerData_;
        std::unique_ptr<bluez_impl::LEAdvertisement> advertisement_;
        std::unique_ptr<bluez_impl::LEAdvertisingReenabler> advertisingReenabler_;

        struct AdapterState {
            std::optional<bool> powered;
            std::optional<bool> discoverable;
            std::optional<bool> pairable;
        } savedAdapterState_;
    };

} // namespace quasar
