#pragma once

#include "blue_alsa_pcm.h"
#include "media_player.h"
#include "media_transport.h"

#include <yandex_io/libs/bluetooth/bluez/dbus/BlueAlsaManager.proxy.h>

#include <yandex_io/libs/bluetooth/bluetooth.h>

#include <yandex_io/libs/base/named_callback_queue.h>

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

#include <memory>

namespace quasar {

    using PropertiesProxy = sdbus::ProxyInterfaces<sdbus::Properties_proxy>;
    using ObjectManagerProxy = sdbus::ProxyInterfaces<sdbus::ObjectManager_proxy>;
    using BlueAlsaManagerProxy = sdbus::ProxyInterfaces<org::bluealsa::Manager1_proxy>;

    class BluezBluetoothImpl final
        : public Bluetooth,
          public PropertiesProxy,
          public ObjectManagerProxy,
          public BlueAlsaManagerProxy,
          public bluez_impl::MediaPlayer::Listener,
          public bluez_impl::MediaTransport::Listener,
          public std::enable_shared_from_this<BluezBluetoothImpl> {
    public:
        explicit BluezBluetoothImpl(const std::string& name);

        ~BluezBluetoothImpl() override;

        int setName(const std::string& name) override;

        int scanNetworks() override; // TODO: Implement

        int stopScanNetworks() override; // TODO: Implement

        int disconnectAll(BtRole role) override; // TODO: Implement

        int pairWithSink(const BtNetwork& network) override; // TODO: Implement

        int setVisibility(bool isDiscoverable, bool isConnectable) override;

        int asSinkPlayNext(const BtNetwork& network) override;

        int asSinkPlayPrev(const BtNetwork& network) override;

        int asSinkPlayPause(const BtNetwork& network) override;

        int asSinkPlayStart(const BtNetwork& network) override;

        int asSinkSetVolumeAbs(int volume) override; // TODO: Implement

        int powerOn() override;

        int powerOff() override;

        void freeAudioFocus() override; // TODO: Implement

        void takeAudioFocus() override; // TODO: Implement

        PowerState getPowerState() const override;

        bool isAsSinkPlaying() const override;

        void factoryReset() override; // TODO: Implement

    private:
        /* from PropertiesProxy */
        void onPropertiesChanged(const std::string& interfaceName,
                                 const std::map<std::string, sdbus::Variant>& changedProperties,
                                 const std::vector<std::string>& invalidatedProperties) override;

        /* from ObjectManagerProxy */
        void onInterfacesAdded(const sdbus::ObjectPath& objectPath,
                               const std::map<std::string,
                                              std::map<std::string, sdbus::Variant>>& interfacesAndProperties) override;
        void onInterfacesRemoved(const sdbus::ObjectPath& objectPath, const std::vector<std::string>& interfaces) override;

        /* from MediaPlayer::Listener */
        void onPlaying() override;
        void onStopped() override;
        void onPaused() override;
        void onError() override;
        void onTrackInfo(const Bluetooth::TrackInfo& trackInfo) override;

        /* from MediaTransport::Listener */
        void onVolumeChanged(uint16_t volume) override;

        /* from BlueAlsaManagerProxy */
        void onPCMAdded(const sdbus::ObjectPath& path, const std::map<std::string, sdbus::Variant>& props) override;
        void onPCMRemoved(const sdbus::ObjectPath& path) override;

        static SinkEvent eventFromState(bool isDiscoverable, bool isPairable);
        int powerOnOff(bool powerState);
        void onSourceDisconnected();

    private:
        const std::string adapterPath_;
        std::unique_ptr<bluez_impl::BlueAlsaPcm> blueAlsaPcm_;
        std::shared_ptr<bluez_impl::MediaPlayer> mediaPlayer_;
        std::shared_ptr<bluez_impl::MediaTransport> mediaTransport_;
        std::atomic<bool> isPlaying_{false};
        NamedCallbackQueue callbackQueue_{"BluezBluetooth"};
        std::atomic<bool> isFadedOut_{false};
        uint16_t stashedVolume_;
    };

} // namespace quasar
