#include "gatt_application.h"

#include <yandex_io/libs/logging/logging.h>

using namespace bluez_impl;

GattApplication::GattApplication(sdbus::IConnection& connection, std::string objectPath)
    : sdbus::AdaptorInterfaces<sdbus::ObjectManager_adaptor>(connection, std::move(objectPath))
{
    registerAdaptor();
    YIO_LOG_INFO("Gatt application created");
}

GattApplication::~GattApplication()
{
    unregisterAdaptor();
}

void GattApplication::addGattService(std::shared_ptr<IGattService> servicePtr)
{
    const auto name = servicePtr->getName();
    if (services_.count(name)) {
        throw std::runtime_error{"Service with name " + name + " is already present"};
    }

    const auto servicePath = getObjectPath() + "/service" + std::to_string(services_.size());
    services_[name] = std::make_shared<bluez_impl::GattService>(getObject().getConnection(), servicePath, std::move(servicePtr));
}

void GattApplication::addGattCharacteristic(const std::string& gattServiceName, std::shared_ptr<IGattCharacteristic> characteristic)
{
    if (!services_.count(gattServiceName)) {
        throw std::runtime_error{"Service with name " + gattServiceName + " was not created"};
    }

    services_[gattServiceName]->addCharacteristic(std::move(characteristic));
}

std::vector<std::string> GattApplication::getServiceUUIDs()
{
    std::vector<std::string> uuids;
    for (const auto& [name, service] : services_) {
        uuids.emplace_back(service->getUuid());
    };
    return uuids;
}
