#pragma once

#include "gatt_service.h"

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

namespace bluez_impl {

    /**
     * Represents ObjectManager on "ru.yandex.quasar" bus
     * that contains all GattServices, GattCharacteristics and GattDescriptors
     * See https://git.kernel.org/pub/scm/bluetooth/bluez.git/tree/doc/gatt-api.txt for more info
     */
    class GattApplication final: public sdbus::AdaptorInterfaces<sdbus::ObjectManager_adaptor> {
    public:
        GattApplication(sdbus::IConnection& connection, std::string objectPath);

        ~GattApplication();

        void addGattService(std::shared_ptr<IGattService> servicePtr);

        void addGattCharacteristic(const std::string& gattServiceName, std::shared_ptr<IGattCharacteristic> characteristic);

        std::vector<std::string> getServiceUUIDs();

    private:
        std::map<std::string, std::shared_ptr<bluez_impl::GattService>> services_;
    };

} // namespace bluez_impl
