#pragma once

#include <yandex_io/libs/bluetooth/bluez/dbus/GattCharacteristic.adaptor.h>

#include <yandex_io/libs/bluetooth/gatt/i_gatt_characteristics.h>

namespace bluez_impl {

    class GattCharacteristic final: public sdbus::AdaptorInterfaces<org::bluez::GattCharacteristic1_adaptor, sdbus::Properties_adaptor> {
    public:
        static constexpr uint16_t MIN_MTU = 23;

        GattCharacteristic(sdbus::IConnection& connection, std::string servicePath, uint16_t index, std::shared_ptr<IGattCharacteristic> charPtr);

        ~GattCharacteristic();

    private: // org.bluez.GattCharacteristic1 Methods
        std::vector<uint8_t> ReadValue(const std::map<std::string, sdbus::Variant>& options) override;

        void WriteValue(const std::vector<uint8_t>& value, const std::map<std::string, sdbus::Variant>& options) override;

        void StartNotify() override;

        void StopNotify() override;

        void Confirm() override;

    private: // org.bluez.GattCharacteristic1 Properties
        std::string UUID() override;

        sdbus::ObjectPath Service() override;

        std::vector<std::string> Flags() override;

        std::vector<sdbus::ObjectPath> Descriptors() override;

        uint16_t Handle() override;

        void Handle(const uint16_t& value) override;

        std::vector<uint8_t> Value() override;

    private:
        const static std::set<std::string> BLUEZ_GATT_CHAR_FLAGS;

        const sdbus::ObjectPath service_;
        std::shared_ptr<IGattCharacteristic> characteristicPtr_;
        const std::vector<std::string> flags_;

        uint16_t handle_ = 0x0000;

    private:
        class BluezFlags final {
        public:
            static std::vector<std::string> covertFromQuasarPermission(const std::set<gatt_permission::GattPermission>& permissions);

            static std::string covertFromQuasarPermission(gatt_permission::GattPermission permission);

            static constexpr const char* BROADCAST = "broadcast";
            static constexpr const char* READ = "read";
            static constexpr const char* WRITE_WO_RESPONSE = "write-without-response";
            static constexpr const char* WRITE = "write";
            static constexpr const char* NOTIFY = "notify";
            static constexpr const char* INDICATE = "indicate";
            static constexpr const char* AUTH_SIGNED_WRITES = "authenticated-signed-writes";
            static constexpr const char* EXTENDED_PROPERTIES = "extended-properties";
            static constexpr const char* RELIABLE_WRITE = "reliable-write";
            static constexpr const char* WRITABLE_AUXILIARIES = "writable-auxiliaries";
            static constexpr const char* ENCRYPT_READ = "encrypt-read";
            static constexpr const char* ENCRYPT_WRITE = "encrypt-write";
            static constexpr const char* ENCRYPT_AUTH_READ = "encrypt-authenticated-read";
            static constexpr const char* ENCRYPT_AUTH_WRITE = "encrypt-authenticated-write";
            static constexpr const char* SECURE_READ = "secure-read";
            static constexpr const char* SECURE_WRITE = "secure-write";
            static constexpr const char* AUTHORIZE = "authorize";
        };
    };

} // namespace bluez_impl
