#include "gatt_manager.h"

#include "common.h"

#include <yandex_io/libs/logging/logging.h>

YIO_DEFINE_LOG_MODULE("bluez");

using namespace bluez_impl;

GattManager::GattManager(sdbus::IConnection& connection, std::string objectPath)
    : sdbus::ProxyInterfaces<org::bluez::GattManager1_proxy>(connection, BLUEZ_BUS, std::move(objectPath))
{
    registerProxy();
}

GattManager::~GattManager()
{
    for (auto& app : registeredApplications_) {
        UnregisterApplication(app);
    }
    unregisterProxy();
}

sdbus::PendingAsyncCall GattManager::RegisterApplication(const sdbus::ObjectPath& application,
                                                         const std::map<std::string, sdbus::Variant>& options)
{
    YIO_LOG_INFO("Registering gatt app: " << application);
    registeredApplications_.insert(application);
    return GattManager1_proxy::RegisterApplication(application, options);
}

void GattManager::UnregisterApplication(const sdbus::ObjectPath& application)
{
    registeredApplications_.erase(application);
    GattManager1_proxy::UnregisterApplication(application);
}

void GattManager::onRegisterApplicationReply(const sdbus::Error* error) {
    if (error) {
        YIO_LOG_ERROR_EVENT("GattManager.OnRegisterApplicationReply", "RegisterApplication() error: " << error->getName() << " with message: " << error->getMessage());
    } else {
        YIO_LOG_INFO("RegisterApplication() finished successfully");
    }
}
