#pragma once

#include <yandex_io/libs/bluetooth/bluez/dbus/GattManager.proxy.h>

#include <set>

namespace bluez_impl {

    class GattManager final: public sdbus::ProxyInterfaces<org::bluez::GattManager1_proxy> {
    public:
        GattManager(sdbus::IConnection& connection, std::string objectPath);

        ~GattManager();

        sdbus::PendingAsyncCall RegisterApplication(const sdbus::ObjectPath& application,
                                                    const std::map<std::string, sdbus::Variant>& options);

        void UnregisterApplication(const sdbus::ObjectPath& application);

    private:
        void onRegisterApplicationReply(const sdbus::Error* error) override;

    private:
        std::set<sdbus::ObjectPath> registeredApplications_;
    };

} // namespace bluez_impl
