#include "gatt_service.h"

using namespace bluez_impl;

GattService::GattService(sdbus::IConnection& connection, std::string objectPath, std::shared_ptr<IGattService> servicePtr)
    : sdbus::AdaptorInterfaces<org::bluez::GattService1_adaptor, sdbus::Properties_adaptor>(connection, std::move(objectPath))
    , name_(servicePtr->getName())
    , uuid_(servicePtr->getUuid())
{
    registerAdaptor();

    YIO_LOG_INFO("Service " << name_ << " path: " << getObjectPath() << " created successfully");
}

GattService::~GattService()
{
    unregisterAdaptor();
}

void GattService::addCharacteristic(std::shared_ptr<IGattCharacteristic> characteristicPtr)
{
    const auto name = characteristicPtr->getName();
    if (characteristics_.count(name)) {
        throw std::runtime_error{"Characteristic with name " + name + " is already present in service " + name_};
    }

    characteristics_[name] = std::make_shared<GattCharacteristic>(getObject().getConnection(), getObjectPath(), characteristics_.size(), std::move(characteristicPtr));
}

std::string GattService::getUuid()
{
    return uuid_;
}

std::string GattService::UUID()
{
    return uuid_;
}

bool GattService::Primary()
{
    return true;
}

uint16_t GattService::Handle()
{
    YIO_LOG_INFO("Getting service \'" << name_ << "\' handle: " << handle_);
    return handle_;
}

void GattService::Handle(const uint16_t& value)
{
    YIO_LOG_INFO("Setting new service \'" << name_ << "\' handle: " << std::to_string(value));
    handle_ = value;

    emitPropertiesChangedSignal(GattService1_adaptor::INTERFACE_NAME, {"Handle"});
}
