#pragma once

#include "gatt_characteristic.h"

#include <yandex_io/libs/bluetooth/bluez/dbus/GattService.adaptor.h>

#include <yandex_io/libs/bluetooth/gatt/i_gatt_service.h>

#include <yandex_io/libs/logging/logging.h>

namespace bluez_impl {

    class GattService final: public sdbus::AdaptorInterfaces<org::bluez::GattService1_adaptor, sdbus::Properties_adaptor> {
    public:
        GattService(sdbus::IConnection& connection, std::string objectPath, std::shared_ptr<IGattService> servicePtr);

        ~GattService();

        void addCharacteristic(std::shared_ptr<IGattCharacteristic> characteristicPtr);

        std::string getUuid();

    protected:
        std::string UUID() override;

        bool Primary() override;

        uint16_t Handle() override;

        void Handle(const uint16_t& value) override;

    private:
        const std::string name_;
        const std::string uuid_;
        uint16_t handle_ = 0x0000;
        std::map<std::string, std::shared_ptr<GattCharacteristic>> characteristics_;
    };

} // namespace bluez_impl
