#include "le_advertisement.h"

#include <yandex_io/libs/logging/logging.h>

using namespace bluez_impl;

LEAdvertisement::LEAdvertisement(sdbus::IConnection& connection, std::string objectPath, uint16_t manufactId,
                                 std::vector<uint8_t> manufactData, std::vector<std::string> serviceUuids)
    : sdbus::AdaptorInterfaces<org::bluez::LEAdvertisement1_adaptor>(connection, std::move(objectPath))
    , manufactId_(manufactId)
    , manufactData_(std::move(manufactData))
    , serviceUuids_(std::move(serviceUuids))
{
    registerAdaptor();
}

LEAdvertisement::~LEAdvertisement()
{
    unregisterAdaptor();
}

void LEAdvertisement::Release()
{
    YIO_LOG_DEBUG(__func__);
}

std::vector<std::string> LEAdvertisement::ServiceUUIDs()
{
    return serviceUuids_;
}

std::string LEAdvertisement::Type()
{
    YIO_LOG_DEBUG(__func__);
    return "peripheral";
}

std::vector<std::string> LEAdvertisement::Includes()
{
    YIO_LOG_DEBUG(__func__);
    return {"local-name"};
}

std::map<uint16_t, sdbus::Variant> LEAdvertisement::ManufacturerData()
{
    YIO_LOG_DEBUG(__func__);
    return {
        {manufactId_, manufactData_}};
}

bool LEAdvertisement::Discoverable()
{
    YIO_LOG_DEBUG(__func__);
    return true;
}
