#pragma once

#include <yandex_io/libs/bluetooth/bluez/dbus/LEAdvertisement.adaptor.h>

namespace bluez_impl {

    class LEAdvertisement final: public sdbus::AdaptorInterfaces<org::bluez::LEAdvertisement1_adaptor> {
    public:
        LEAdvertisement(sdbus::IConnection& connection, std::string objectPath, uint16_t manufactId,
                        std::vector<uint8_t> manufactData, std::vector<std::string> serviceUuids);

        ~LEAdvertisement();

    private:
        void Release() override;

        std::string Type() override;

        std::vector<std::string> ServiceUUIDs() override;

        std::vector<std::string> Includes() override;

        std::map<uint16_t, sdbus::Variant> ManufacturerData() override;

        bool Discoverable() override;

    private:
        const uint16_t manufactId_;
        const std::vector<uint8_t> manufactData_;
        const std::vector<std::string> serviceUuids_;
    };

} // namespace bluez_impl
