#include "le_advertising_manager.h"

#include "common.h"

#include <yandex_io/libs/logging/logging.h>

YIO_DEFINE_LOG_MODULE("bluez");

using namespace bluez_impl;

LEAdvertisingManager::LEAdvertisingManager(sdbus::IConnection& connection, std::string objectPath)
    : sdbus::ProxyInterfaces<org::bluez::LEAdvertisingManager1_proxy>(connection, BLUEZ_BUS, std::move(objectPath))
{
    registerProxy();
}

LEAdvertisingManager::~LEAdvertisingManager()
{
    for (const auto& adv : registeredAdvertisements_) {
        org::bluez::LEAdvertisingManager1_proxy::UnregisterAdvertisement(adv);
    }

    unregisterProxy();
}

sdbus::PendingAsyncCall LEAdvertisingManager::RegisterAdvertisement(const sdbus::ObjectPath& advertisement,
                                                                    const std::map<std::string, sdbus::Variant>& options)
{
    YIO_LOG_INFO("Registering advertisement: " << advertisement);
    registeredAdvertisements_.insert(advertisement);
    return org::bluez::LEAdvertisingManager1_proxy::RegisterAdvertisement(advertisement, options);
}

void LEAdvertisingManager::UnregisterAdvertisement(const sdbus::ObjectPath& advertisement)
{
    registeredAdvertisements_.erase(advertisement);
    org::bluez::LEAdvertisingManager1_proxy::UnregisterAdvertisement(advertisement);
}

void LEAdvertisingManager::onRegisterAdvertisementReply(const sdbus::Error* error) {
    if (error) {
        YIO_LOG_ERROR_EVENT("LEAdvertisingManager.OnRegisterApplicationReply", "RegisterAdvertisement() error: " << error->getName() << " with message: " << error->getMessage());
    } else {
        YIO_LOG_INFO("RegisterAdvertisement() finished successfully");
    }
}
