#pragma once

#include <yandex_io/libs/bluetooth/bluez/dbus/LEAdvertisingManager.proxy.h>

#include <set>

namespace bluez_impl {

    class LEAdvertisingManager final: public sdbus::ProxyInterfaces<org::bluez::LEAdvertisingManager1_proxy> {
    public:
        LEAdvertisingManager(sdbus::IConnection& connection, std::string objectPath);

        ~LEAdvertisingManager();

        sdbus::PendingAsyncCall RegisterAdvertisement(const sdbus::ObjectPath& advertisement,
                                                      const std::map<std::string, sdbus::Variant>& options);

        void UnregisterAdvertisement(const sdbus::ObjectPath& advertisement);

    private:
        void onRegisterAdvertisementReply(const sdbus::Error* error) override;

    private:
        std::set<sdbus::ObjectPath> registeredAdvertisements_;
    };

} // namespace bluez_impl
