#pragma once

#include "bluetooth_device.h"

#include <yandex_io/libs/bluetooth/bluez/dbus/MediaPlayer.proxy.h>

#include <yandex_io/libs/bluetooth/bluetooth.h>

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

#include <memory>

namespace bluez_impl {

    class MediaPlayer final: public sdbus::ProxyInterfaces<org::bluez::MediaPlayer1_proxy, sdbus::Properties_proxy> {
    public:
        class Listener {
        public:
            virtual ~Listener() = default;
            virtual void onPlaying() = 0;
            virtual void onStopped() = 0;
            virtual void onPaused() = 0;
            virtual void onError() = 0;
            virtual void onTrackInfo(const Bluetooth::TrackInfo& trackInfo) = 0;
        };

        MediaPlayer(std::string dbusPath, std::weak_ptr<Listener> listener);
        ~MediaPlayer();

        bool isPlaying();
        std::shared_ptr<BluetoothDevice> getDeviceProxy();

    private:
        /* from Properties_proxy */
        void onPropertiesChanged(const std::string& interfaceName,
                                 const std::map<std::string, sdbus::Variant>& changedProperties,
                                 const std::vector<std::string>& invalidatedProperties) override;

        void onStatusChanged(std::string_view status);
        void onTrackChanged(const std::map<std::string, sdbus::Variant>& trackData);
        void onPositionChanged(uint32_t positionMs);

    private:
        std::weak_ptr<Listener> listener_;
        std::shared_ptr<BluetoothDevice> bluetoothDevice_;
        Bluetooth::TrackInfo trackInfo_;
    };

} // namespace bluez_impl
