#pragma once

#include "bluetooth_device.h"

#include <yandex_io/libs/bluetooth/bluez/dbus/MediaTransport.proxy.h>

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

#include <memory>

namespace bluez_impl {

    class MediaTransport final: public sdbus::ProxyInterfaces<org::bluez::MediaTransport1_proxy, sdbus::Properties_proxy> {
    public:
        class Listener {
        public:
            virtual ~Listener() = default;
            virtual void onVolumeChanged(uint16_t volume) = 0;
        };

        explicit MediaTransport(std::string objectPath, std::weak_ptr<Listener> listener);
        ~MediaTransport();

        std::shared_ptr<BluetoothDevice> getDeviceProxy();
        uint16_t getVolume() const;
        void setVolume(uint16_t volume);

    private:
        void onPropertiesChanged(const std::string& interfaceName,
                                 const std::map<std::string, sdbus::Variant>& changedProperties,
                                 const std::vector<std::string>& invalidatedProperties) override;
        void onVolumeChanged(uint16_t volume);

    private:
        std::weak_ptr<Listener> listener_;
        std::shared_ptr<BluetoothDevice> bluetoothDevice_;
        uint16_t volume_;
    };

} // namespace bluez_impl
