#pragma once

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

namespace bluez_impl {

    /**
     * Default object manager for object path finding
     */
    class ObjectManager final: public sdbus::ProxyInterfaces<sdbus::ObjectManager_proxy> {
    public:
        explicit ObjectManager(std::string serviceName, std::string path);
        ~ObjectManager();

        static sdbus::ObjectPath getObjectPath(const std::string& serviceName,
                                               const std::string& omPath,
                                               const std::string& interface);
        static sdbus::ObjectPath getBluezObjectPath(const std::string& interface);

        void onInterfacesAdded(const sdbus::ObjectPath& objectPath,
                               const std::map<std::string,
                                              std::map<std::string, sdbus::Variant>>& interfacesAndProperties) override;

        void onInterfacesRemoved(const sdbus::ObjectPath& objectPath, const std::vector<std::string>& interfaces) override;
    };

} // namespace bluez_impl
