#include "profile_manager.h"

#include "common.h"

#include <yandex_io/libs/logging/logging.h>

using namespace bluez_impl;

ProfileManager::ProfileManager(sdbus::IConnection& connection, std::string objectPath)
    : sdbus::ProxyInterfaces<org::bluez::ProfileManager1_proxy>(connection, BLUEZ_BUS, std::move(objectPath))
{
    registerProxy();
}

ProfileManager::~ProfileManager()
{
    for (const auto& pr : registeredProfiles_) {
        org::bluez::ProfileManager1_proxy::UnregisterProfile(pr);
    }

    unregisterProxy();
}

void ProfileManager::RegisterProfile(const sdbus::ObjectPath& profile, const std::string& uuid,
                                     const std::map<std::string, sdbus::Variant>& options)
{
    registeredProfiles_.insert(profile);
    org::bluez::ProfileManager1_proxy::RegisterProfile(profile, uuid, options);
    YIO_LOG_INFO("Profile registered");
}

void ProfileManager::UnregisterProfile(const sdbus::ObjectPath& profile)
{
    registeredProfiles_.erase(profile);
    org::bluez::ProfileManager1_proxy::UnregisterProfile(profile);
    YIO_LOG_INFO("Profile unregistered");
}
