#pragma once

#include <yandex_io/libs/bluetooth/bluez/dbus/ProfileManager.proxy.h>

#include <set>

namespace bluez_impl {

    class ProfileManager final: public sdbus::ProxyInterfaces<org::bluez::ProfileManager1_proxy> {
    public:
        ProfileManager(sdbus::IConnection& connection, std::string objectPath);

        ~ProfileManager();

        void RegisterProfile(const sdbus::ObjectPath& profile, const std::string& uuid, const std::map<std::string, sdbus::Variant>& options);

        void UnregisterProfile(const sdbus::ObjectPath& profile);

    private:
        std::set<sdbus::ObjectPath> registeredProfiles_;
    };

} // namespace bluez_impl
