#pragma once

#include <yandex_io/libs/bluetooth/bluez/dbus/Profile.adaptor.h>

namespace bluez_impl {

    class ServerProfile final: public sdbus::AdaptorInterfaces<org::bluez::Profile1_adaptor> {
    public:
        static constexpr auto uuid = "93d80732-8bb0-11ea-bc55-0242ac130003";
        static constexpr std::uint16_t channel{7};
        static constexpr std::uint16_t version{0};

        ServerProfile(sdbus::IConnection& connection, std::string objectPath);

        ~ServerProfile();

    protected:
        void Release() override;

        void NewConnection(const sdbus::ObjectPath& device, const sdbus::UnixFd& fd,
                           const std::map<std::string, sdbus::Variant>& fd_properties) override;

        void RequestDisconnection(const sdbus::ObjectPath& device) override;

    private:
        static void Serve(const sdbus::UnixFd& fd);

        static void SetBlocking(int fd) noexcept;
    };

} // namespace bluez_impl
