#include "dummy_gatt_characteristic.h"

#include <yandex_io/libs/logging/logging.h>

using namespace quasar;
using namespace gatt_permission;

DummyGattCharacteristic::DummyGattCharacteristic(std::string name, std::string uuid, std::set<GattPermission> permissions)
    : IGattCharacteristic(name, uuid, permissions)
{
}

void DummyGattCharacteristic::setValue(const std::vector<uint8_t>& val)
{
    value_ = val;
}

std::vector<uint8_t> DummyGattCharacteristic::getValue() const {
    return value_;
}

std::vector<uint8_t> DummyGattCharacteristic::readValueImpl(const Mac& mac, uint16_t mtu, uint16_t offset)
{
    YIO_LOG_INFO("Read request from device: " << mac << ", mtu: " << mtu << ", offset: " << offset);
    return value_;
}

void DummyGattCharacteristic::writeValueImpl(const Mac& mac, const std::vector<uint8_t>& val)
{
    YIO_LOG_INFO("Write request from device: " << mac);
    value_ = val;
}
