#pragma once

#include "i_gatt_characteristics.h"

#include <set>

namespace quasar {

    class DummyGattCharacteristic: public IGattCharacteristic {
    public:
        DummyGattCharacteristic(std::string name, std::string uuid, std::set<gatt_permission::GattPermission> permissions);
        ~DummyGattCharacteristic() = default;

        void setValue(const std::vector<uint8_t>& val);
        std::vector<uint8_t> getValue() const override;

        std::vector<uint8_t> readValueImpl(const Mac& mac, uint16_t mtu, uint16_t offset) override;
        void writeValueImpl(const Mac& mac, const std::vector<uint8_t>& val) override;

    private:
        std::vector<uint8_t> value_;
    };

} // namespace quasar
