#include "gatt_permission.h"

#include <algorithm>
#include <array>
#include <string>

using namespace gatt_permission;

namespace {

    const std::array<std::string, static_cast<int>(GattPermission::MAX_VALUE) + 1> STRING_VALUES{
        "broadcast",
        "read",
        "write-without-response",
        "write",
        "notify",
        "indicate",
        "authenticated-signed-writes",
        "extended-properties",
        "reliable-write",
        "writable-auxiliaries",
        "encrypt-read",
        "encrypt-write",
        "encrypt-authenticated-read",
        "encrypt-authenticated-write",
        "secure-read",
        "secure-write",
        "authorize",
    };

} // namespace

std::string gatt_permission::permissionToString(GattPermission permission) {
    return STRING_VALUES[static_cast<int>(permission)];
}

GattPermission gatt_permission::stringToPermission(const std::string& strPermission) {
    auto result = std::find(STRING_VALUES.begin(), STRING_VALUES.end(), strPermission);
    if (result != STRING_VALUES.end()) {
        return static_cast<GattPermission>(result - STRING_VALUES.begin());
    }
    throw std::runtime_error(std::string("No such permission: ") + strPermission);
}
