#pragma once

#include <string>

namespace gatt_permission {

    enum class GattPermission {
        BROADCAST = 0,
        READ,
        WRITE_WO_RESPONSE,
        WRITE,
        NOTIFY,
        INDICATE,
        AUTH_SIGNED_WRITES,
        EXTENDED_PROPERTIES,
        RELIABLE_WRITE,
        WRITABLE_AUXILIARIES,
        ENCRYPT_READ,
        ENCRYPT_WRITE,
        ENCRYPT_AUTH_READ,
        ENCRYPT_AUTH_WRITE,
        SECURE_READ,
        SECURE_WRITE,
        AUTHORIZE,

        MAX_VALUE = AUTHORIZE
    };

    std::string permissionToString(GattPermission permission);
    GattPermission stringToPermission(const std::string& strPermission);

} // namespace gatt_permission
