#pragma once

#include "gatt_permission.h"

#include <cstdint>
#include <set>
#include <stdexcept>
#include <string>
#include <vector>

class IGattCharacteristic {
public:
    class GattPermissionException: public std::runtime_error {
    public:
        GattPermissionException(gatt_permission::GattPermission permission);
    };

    using NotifyCallback = std::function<void()>;

public:
    IGattCharacteristic(std::string name, std::string uuid, std::set<gatt_permission::GattPermission> permissions);
    virtual ~IGattCharacteristic();

    using Mac = std::string;
    /**
     * @brief Methods to read/write characteristic value
     * @note: Minimum: 23 bytes, Maximum: 512 bytes
     */
    std::vector<uint8_t> readValue(const Mac& mac, uint16_t mtu, uint16_t offset);
    void writeValue(const Mac& mac, const std::vector<uint8_t>& val);

    virtual std::vector<uint8_t> getValue() const = 0;

    void enableNotifications(NotifyCallback cb);

    const std::string& getName() const;
    const std::string& getUuid() const;
    const std::set<gatt_permission::GattPermission>& getPermissions() const;

protected:
    virtual std::vector<uint8_t> readValueImpl(const Mac& mac, uint16_t mtu, uint16_t offset) = 0;
    virtual void writeValueImpl(const Mac& mac, const std::vector<uint8_t>& val) = 0;

    void notify();

protected:
    const std::string name_;
    const std::string uuid_;
    const std::set<gatt_permission::GattPermission> permissions_;

    NotifyCallback cb_;
};
