#pragma once

#include <yandex_io/libs/device/defines.h>

#include <json/json.h>

#include <atomic>

namespace YandexIO {

    using Port = int;
    using ConfigPatterns = std::map<std::string, std::string>;

    class Configuration {
    public:
        Configuration(const std::string& fileName, const ConfigPatterns& extra);
        Configuration(Json::Value config);

        Port getServicePort(const std::string& serviceName) const;

        bool hasServiceConfig(const std::string& serviceName) const;
        const Json::Value& getServiceConfig(const std::string& serviceName) const;
        const Json::Value& getCommonConfig() const;
        const Json::Value& getFullConfig() const;
        Json::Value getSupportedFeatures() const;
        bool isFeatureSupported(const std::string& feature) const;

        std::string getBackendUrl() const;
        std::string getDeviceType() const;

        std::string getDevBackendFlagPath() const;
        // -----------------For tests only----------------------
        // Simple marker used to make sure that getMutableConfig will not be used
        // in production code
        struct TestGuard {
        };
        // Tests should pass guard argument just for ensure that it exists
        Json::Value& getMutableConfig(const TestGuard& guard);
        // -----------------For tests only----------------------

        Configuration(const Configuration&) = delete;

        Configuration& operator=(const Configuration&) = delete;

    private:
        void forceDevParams();

        Json::Value config_;
    };

    Json::Value preprocessConfig(Json::Value config, const ConfigPatterns& extra);

    std::shared_ptr<Configuration> makeConfiguration(const std::string& configPath = DEFAULT_CONFIG_PATH, const ConfigPatterns& extra = {});

} // namespace YandexIO
