#pragma once

#include <yandex_io/libs/json_utils/json_utils.h>

#include <mutex>

namespace quasar {

    class ConfigurationHelper {
    public:
        explicit ConfigurationHelper(Json::Value initialConfig);

        /*
         * Returns diff between current config and initial config pathched with new config
         *
         * * If field is present in current but not in new config,
         *   diff will contain its value from initial config
         * * Diff is calculated recursively for nested objects, but not for the arrays
         */
        Json::Value getConfigurationUpdate(const Json::Value& config);
        const Json::Value& getCurrentConfig() const;

    private:
        Json::Value getConfigDiff(const Json::Value& currentConfig, const Json::Value& newConfig);

    private:
        const Json::Value initialConfig_;
        Json::Value currentConfig_;

        mutable std::mutex mutex_;
    };

} // namespace quasar
