#pragma once

#include <boost/algorithm/string.hpp>

#include <exception>
#include <string>

namespace quasar {

    static const int CLOSURE_MAX_ITER = 10;

    template <typename T>
    std::string bulkReplace(const std::string& input, const T& mp) {
        std::string result = input;
        for (const auto& p : mp) {
            boost::replace_all(result, "${" + p.first + "}", p.second);
        }
        return result;
    }

    template <typename T>
    void closure(T& mp) {
        bool any_change;
        for (int i = 0; i < CLOSURE_MAX_ITER; ++i) {
            any_change = false;
            for (const auto& p : mp) {
                auto new_val = bulkReplace(p.second, mp);
                if (new_val != p.second) {
                    any_change = true;
                    mp[p.first] = new_val;
                }
            }
            if (!any_change) {
                return;
            }
        }
        throw std::runtime_error("Maximum substitution depth exceeded");
    }

} // namespace quasar
