#pragma once

#include <yandex_io/libs/device/device.h>

#include <alice/megamind/protos/common/experiments.pb.h>
#include <yandex_io/protos/capabilities/device_state_capability.pb.h>

#include <json/json.h>

#include <string>
#include <unordered_set>

namespace quasar {

    class FeaturesConfig {
    public:
        explicit FeaturesConfig(Json::Value fileConfig);
        explicit FeaturesConfig(const NAlice::TDeviceStateCapability::TState& state);

        const std::unordered_set<TString>& getSupportedFeatures() const;
        const std::unordered_set<TString>& getUnsupportedFeatures() const;
        const NAlice::TExperimentsProto& getExperiments() const;

        static Json::Value formatFeatures(const std::unordered_set<TString>& features);
        static Json::Value formatExperiments(const NAlice::TExperimentsProto& experiments);

        void addSupportedFeature(const TString& feature);

        void setSupportedFeatures(const Json::Value& features);
        void setUnsupportedFeatures(const Json::Value& features);
        void setExperiments(const Json::Value& experiments);

        void processNewConfig(const Json::Value& config);

        void merge(const FeaturesConfig& src);

    private:
        void update();

    private:
        static std::unordered_set<TString> featuresFromConfig(const Json::Value& config, const std::string& field);
        static void experimentsFromArray(const Json::Value& config, NAlice::TExperimentsProto& experiments);
        static void experimentsFromDict(const Json::Value& config, NAlice::TExperimentsProto& experiments);

    private:
        std::unordered_set<TString> supportedFeatures_;
        std::unordered_set<TString> unSupportedFeatures_;
        NAlice::TExperimentsProto experiments_;

        Json::Value defaultConfig_;
        Json::Value overrideConfig_;
    };

} // namespace quasar
